//
//  GSGlyphsInfo+FeatureGenerator.h
//  GlyphsCore
//
//  Created by Georg Seifert on 30.09.12.
//  Copyright (c) 2012 schriftgestaltung.de. All rights reserved.
//
@class GSFont;
@class GSFeature;
@class GSClass;

#define GSAutomaticCodeMarker @"# Automatic Code"

/**
 Generates the OT features for the Font.
 */
@interface GSFeatureGenerator : NSObject

/**
 This retunes the feature genrator object.

 @return This is always the same object
 */
+ (GSFeatureGenerator *)sharedManager;

/** resets the generator to a clean state. Call that between generation for different fonts */
- (void)reset;
/** Generates all default features

 This equivalent with pressing the Update button in font info

 @param font a font
 @param error if something goes wrong, retunes an NSError by reference.

 @return NO if there was a problem

 @see updateFeatureForTag:forFont:
 */
- (BOOL)makeFeatures:(GSFont *)font error:(NSError **)error;

/** Updates a particular feature

 If the Feature is not there, it will be added

 @param feature The Feature that should be updated
 @param font    The font object that contains the feature
 @param error if something goes wrong, retunes an NSError by reference.

 @return NO if there was a problem
 */
- (BOOL)updateFeature:(GSFeature *)feature forFont:(GSFont *)font error:(NSError **)error;

/** Updates a particular class

 This cold be the @Uppercase class

 @param tag  The name for the class that should be updated
 @param font The font object that contains the class
 @param error if something goes wrong, retunes an NSError by reference.

 @return NO if there was a problem
 */
- (BOOL)updateClassForTag:(NSString *)tag forFont:(GSFont *)font error:(NSError **)error;

- (BOOL)updateClass:(GSClass *)aClass forFont:(GSFont *)font error:(NSError **)error;
/** Updates a particular prefix

 @param tag  The name for the prefix that should be updated
 @param font The font object that contains the prefix
 @param error if something goes wrong, retunes an NSError by reference.

 @return NO if there was a problem
 */
- (BOOL)updatePrefixForTag:(NSString *)tag forFont:(GSFont *)font error:(NSError **)error;

+ (NSDictionary *)nonCombiningFeatures;

+ (NSArray *)devaLanguages:(GSFont *)font;

+ (NSArray *)defaultClassNames;
@end
